

cd('E:\Google Drive\Projects\HI-SCALE SGP\Data\ARM_Data\Optical Rain Gauge');

currdir = dir;
time = [];
precipmean = [];
precipsd = [];
precipmin = [];
precipmax = [];

for i = 1:length(currdir)
	
	cdfcheck = strfind(currdir(i).name,'.cdf');
	if isempty(cdfcheck)
		continue
	end
	currfile = currdir(i).name;
	startdate = [str2num(currfile(13:16)), str2num(currfile(17:18)), str2num(currfile(19:20)), 0, 0, 0];
	sec_time = ncread(currfile,'time');
	
	currtimemat = repmat(startdate,length(sec_time),1);
	currtimemat(:,6) = currtimemat(:,6) + sec_time;
	currtimemat = datetime(currtimemat);
	time = [time ; currtimemat];
	
	currprecipmean = ncread(currfile,'precip_mean');
	precipmean = [precipmean; currprecipmean];
	
	currprecipsd = ncread(currfile,'precip_sd');
	precipsd = [precipsd ; currprecipsd];
	
	currprecipmin = ncread(currfile,'precip_min');
	precipmin = [precipmean ; currprecipmean];
	
	currprecipmax = ncread(currfile,'precip_max');
	precipmax = [precipmax ; currprecipmax];
	
	
end